/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.activityfolder;

import com.quantumdata.sct.dao.impl.ModelUnitDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.ModelUnitVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.gui.ComplianceTesterToolUI;
import com.quantumdata.sct.gui.activityarea.ToolsActivityArea;
import com.quantumdata.sct.gui.activityfolder.ActivityFolder;
import com.quantumdata.sct.gui.activityfolder.CreateNewUnit;
import com.quantumdata.sct.gui.common.MessageOptionPane;
import com.quantumdata.sct.gui.common.SCTButton;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.common.SCTLabel;
import com.quantumdata.sct.gui.common.SCTPanel;
import com.quantumdata.sct.gui.wizard.IBOHandler;
import com.quantumdata.sct.util.SCTSelection;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class UnitSelectionFolder
extends ActivityFolder
implements ActionListener,
IBOHandler {
    private JList unitList;
    private SCTButton selectUnitBtn;
    private SCTButton createUnitBtn;
    private SCTButton deleteUnitBtn;
    private SCTLabel statusText;
    private Vector units = new Vector();
    private ComplianceTesterToolUI m_toolUI;

    public UnitSelectionFolder(ComplianceTesterToolUI complianceTesterToolUI) {
        super(complianceTesterToolUI, "Device Selection");
        this.m_toolUI = complianceTesterToolUI;
        this.init();
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        SCTPanel sCTPanel = new SCTPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 1, 1);
        SCTLabel sCTLabel = new SCTLabel("Select Device");
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(sCTLabel, gridBagConstraints);
        sCTPanel.add(sCTLabel);
        this.unitList = new JList(this.getAllUnits());
        this.unitList.setFont(SCTConstants.SS_B_14);
        JScrollPane jScrollPane = new JScrollPane(this.unitList);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(2, 5, 2, 25);
        gridBagConstraints2.ipadx = 20;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 4;
        sCTPanel.add((Component)jScrollPane, gridBagConstraints2);
        this.selectUnitBtn = new SCTButton("Select");
        this.selectUnitBtn.addActionListener(this);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(2, 5, 2, 25);
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 5;
        sCTPanel.add((Component)this.selectUnitBtn, gridBagConstraints3);
        this.createUnitBtn = new SCTButton("Create");
        this.createUnitBtn.addActionListener(this);
        gridBagConstraints3.gridy = 6;
        sCTPanel.add((Component)this.createUnitBtn, gridBagConstraints3);
        this.deleteUnitBtn = new SCTButton("Delete");
        this.deleteUnitBtn.addActionListener(this);
        gridBagConstraints3.gridy = 7;
        sCTPanel.add((Component)this.deleteUnitBtn, gridBagConstraints3);
        this.statusText = new SCTLabel("");
        gridBagConstraints3.gridy = 8;
        sCTPanel.add((Component)this.statusText, gridBagConstraints3);
        this.add(sCTPanel);
    }

    public void preSelect() {
        super.preSelect();
        SCTSelection.instance().getIBODialog().setCurrentHandler(this);
        this.getAllUnits();
    }

    private Vector getAllUnits() {
        this.units.clear();
        try {
            String string = SCTSelection.instance().getModelID();
            ModelUnitDAO modelUnitDAO = (ModelUnitDAO)XMLDAOFactory.getModelUnitDAO();
            ModelUnitVO modelUnitVO = null;
            try {
                modelUnitVO = (ModelUnitVO)modelUnitDAO.read(string);
            }
            catch (Exception exception) {
                modelUnitVO = new ModelUnitVO();
                modelUnitVO.setModelId(string);
                modelUnitVO.setNew(true);
                modelUnitVO.setDirty();
                modelUnitDAO.add(modelUnitVO);
            }
            Iterator iterator = modelUnitVO.getUnits().iterator();
            while (iterator.hasNext()) {
                this.units.add(iterator.next());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.units;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.selectUnitBtn) {
            Object e = this.unitList.getSelectedValue();
            if (e == null) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "No device is selected", "Error");
                return;
            }
            if (e != null && e instanceof UnitVO) {
                SCTSelection.instance().setUnit((UnitVO)e);
            }
            ToolsActivityArea toolsActivityArea = new ToolsActivityArea(this.m_toolUI);
            toolsActivityArea.addCDFOnly(this.m_toolUI);
            toolsActivityArea.initialize(this.m_toolUI);
            if (!toolsActivityArea.setUUT()) {
                MessageOptionPane.ShowErrorMessage(this.getMainWindow(), "No connection to the generator defined.  Please go to the Host menu before proceeding.", "ERROR!");
                return;
            }
            this.m_toolUI.setActivityArea(toolsActivityArea);
            this.m_toolUI.shiftTopPanelSelected(-5);
            this.m_toolUI.setBottomPanelSelected(1);
        } else if (actionEvent.getSource() == this.createUnitBtn) {
            try {
                this.handleAction((short)1);
            }
            catch (Exception exception) {}
        } else if (actionEvent.getSource() == this.deleteUnitBtn) {
            try {
                this.handleAction((short)3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String handleAction(short s) throws Exception {
        if (s == 1) {
            UnitVO unitVO = new UnitVO();
            CreateNewUnit createNewUnit = new CreateNewUnit(this.getMainWindow(), unitVO);
            createNewUnit.setVisible(true);
            if (createNewUnit.isSaveButtonPressed()) {
                this.units.add(unitVO);
                this.unitList.setSelectedValue(unitVO, true);
                this.unitList.updateUI();
            }
        } else if (s == 3) {
            Object e = this.unitList.getSelectedValue();
            if (e == null) {
                throw new Exception("No device is selected.");
            }
            if (e != null && e instanceof UnitVO) {
                try {
                    String string = SCTSelection.instance().getModelID();
                    ModelUnitDAO modelUnitDAO = (ModelUnitDAO)XMLDAOFactory.getModelUnitDAO();
                    ModelUnitVO modelUnitVO = (ModelUnitVO)modelUnitDAO.read(string);
                    modelUnitVO.getUnits().remove(e);
                    modelUnitVO.setDirty();
                    modelUnitDAO.update(modelUnitVO);
                    this.getAllUnits();
                    this.unitList.updateUI();
                    return "Successfully removed the device.";
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new Exception("Device could not be removed.");
                }
            }
        }
        return null;
    }

    public boolean isEnabled(short s) {
        if (s == 1) {
            return true;
        }
        return s == 3;
    }
}

